const $ = jQuery;
// import FormSerializer from 'form-serializer';

const progress = `<div class="progress">
<div class="progress__content">
    <span class="progress__message"></span>
    <div class="meter red">
        <span></span>
    </div>
</div>
</div>`;

class AgeGateRegionsAdmin {

    constructor() {
        jQuery('.ag-region__list').sortable({
            placeholder: "ag-region__highlight",
            handle: ".ag-region__handle",
        });

        jQuery('.wrap > form').on('submit', this.submitForm);

        jQuery(document).on('click', '.ag-region__action--add', this.addPanel);
        jQuery(document).on('click', '.ag-region__action--remove', this.removePanel);
        jQuery(document).on('change', '.ag-redirect-type', this.toggleCustomRedirect);
        jQuery(document).on('change', '.ag-region-form', this.validCheck);
        jQuery(document).on('change', '.ag-region__default', this.toggleDefaults);
        jQuery('.ag-regions__action-import').on('click', this.loadOptions);
        jQuery('[name="region-type"]').on('change', this.toggleButtons);
        jQuery(document).on('change', '.ag-region__code', this.updateFieldNames);

        jQuery('.ag-regions__tabs a').on('click', this.switchTab);

        jQuery(document).on('click', '.ag-region__translation-toggle', function (e) {
            jQuery(e.target).closest('.ag-region').find('.ag-region__translations').toggleClass('open');
        });

        if (window.location.hash) {
            this.showTab(window.location.hash);
        }

        this.validCheck();
    }

    toggleDefaults = (e) => {
        $.each($('.ag-region__default'), (index, el) => {
            if (el !== e.target) {
                el.checked = false;
            }
        });
    }

    validCheck = () => {
        const form = document.querySelector('.wrap > form');

        if (form.checkValidity) {
            console.log(form.checkValidity());
            $('input[type="submit"]').prop('disabled', !form.checkValidity());
        }

        // this.showHints();

        return true;
    }

    showHints = () => {
        // console.log('hints');
        // const form = document.querySelector('.ag-region-form');

        // let zero = {}
        // , forbidden = {};

        $('input[value="0"]').each((i, el) => {
            console.log($(el).closest('li').find('.ag-region__field--title').val());
        })

        // Array.from(form.querySelectorAll('input[value="0"]')).forEach((item, idx) => {
        //     zero[idx] = item.closest('li').querySelector('.ag-region__field--title').value;
        // });

        // Array.from(form.querySelectorAll('input[value="-1"]')).forEach((item, idx) => {
        //     forbidden[idx] = item.closest('li').querySelector('.ag-region__field--title').value;
        // });

        // const hintsEl = document.querySelector('.ag-region__hints');
        // hintsEl.innerHTML = '';



        // var list = document.createElement('ul');
        // list.classList.add('ag-region__hint-list');

        // Object.keys(zero).forEach(key => {
        //     let li = document.createElement('li');
        //     li.textContent = `${zero[key]} has an age of 0`;
        //     list.appendChild(li);
        // });

        // hintsEl.appendChild(list);

        // var list = document.createElement('ul');
        // list.classList.add('ag-region__hint-list');

        // Object.keys(forbidden).forEach(key => {
        //     let li = document.createElement('li');
        //     li.textContent = `${zero[key]} has an age of -1`;
        //     list.appendChild(li);
        // });

        // hintsEl.appendChild(list);
    }

    submitForm = (e) => {

        e.preventDefault();
        this.callsLength = false;

        $('.wrap').append(progress);
        $('.progress__message').text('Preparing...');

        const formData = $(e.target).serializeObject();


        const { ag_settings: { region, labels }, action } = formData;
        console.log(region, labels);

        let calls = [];

        if (region) {
            Object.keys(region).forEach((key, index) => {

                const regionData = {}; //Object.assign({}, { region: region[key], index: index});
                regionData[key] = region[key];

                calls.push({
                    region: regionData,
                    index,
                    action,
                    type: 'region',
                });



                // jQuery.ajax({
                //     method: 'POST',
                //     url: ajaxurl,
                //     data: {
                //         region: regionData,
                //         index,
                //         action,
                //     },
                //     dataType: 'JSON',
                //     success: response => {
                //         console.log(response);
                //     }
                // })

            });
        }

        calls.push({
            labels,
            action,
            type: 'labels',
            index: calls.length
        });

        console.log(calls);

        this.doAjaxSave(calls);

    }

    doAjaxSave = (calls) => {

        if (!this.callsLength) {
            this.callsLength = calls.length;
        }

        jQuery.ajax({
            method: 'POST',
            url: ajaxurl,
            data: calls[0],
            // dataType: 'JSON',
            success: (response) => {
                calls.shift();
                if (calls.length) {
                    const percent = (calls[0].index + 1) / this.callsLength * 100;
                    $('.progress__message').text(`${calls[0].index + 1} of ${this.callsLength} items saved`);
                    $('.meter > span').css({ width: `${percent}%` });
                    this.doAjaxSave(calls);
                } else {
                    $('.wrap .progress').remove();
                }


            }
        })
    }

    switchTab = (e) => {
        e.preventDefault();
        this.showTab(jQuery(e.target).attr('href'));
        history.pushState({}, '', e.target.href);

    }

    showTab = (tab) => {
        if (!jQuery(tab).length) {
            tab = '#regions';
        }

        jQuery('.ag-regions__tabs a').removeClass();
        jQuery(`.ag-regions__tabs a[href="${tab}"]`).addClass('current');
        jQuery('.ag-regions__tab').hide();

        const ref = jQuery('[name="_wp_http_referer"]').val();

        const newRef = ref.indexOf('#') > -1 ? `${ref.substr(0, ref.indexOf('#'))}${tab}` : `${ref}${tab}`;

        jQuery('[name="_wp_http_referer"]').val(newRef);
        jQuery(tab).show();
    }

    addPanel = (e) => {
        e.preventDefault();

        const template = wp.template('ag-region');
        const key = jQuery('.ag-region').length;

        const markup = template({
            key,
            set: 'custom',

        });

        const html = jQuery(markup);
        jQuery('.ag-region__list').append(html);

        console.log(html);
        html.find('input:first').focus();
        jQuery('.ag-region-placeholder').remove();
        this.validCheck();
    }

    removePanel = (e) => {
        jQuery(e.target).closest('li').remove();
        this.validCheck();
    }

    toggleButtons = (e) => {
        jQuery('.ag-regions__action-import').prop('disabled', !e.target.value);
    }

    toggleCustomRedirect = (e) => {
        const el = jQuery(e.target).closest('.ag-region__field-group').find('.ag-region__subfield');
        if (e.target.value === 'custom') {
            el.removeClass('hidden');
            el.find('input').prop('disabled', false);
        } else {
            el.addClass('hidden');
            el.find('input').prop('disabled', true);
        }
    }

    loadOptions = (e) => {
        e.preventDefault();

        if (!confirm(`Are you sure?`)) {
            return;
        }

        $('.wrap').append(progress);
        $('.meter > span').css({ width: '80%' });

        const formData = Object.assign({}, e.target.dataset, { action: 'ag_region_import', set: jQuery('[name="region-type"]').val() });

        jQuery.ajax({
            url: ajaxurl,
            data: formData,
            dataType: 'JSON',
            success: response => {
                const { data, type } = response;
                const { set } = formData;

                if (type === 'replace') {
                    jQuery('.ag-region__list').empty();
                }

                const template = wp.template('ag-region');
                let added = 0;

                Object.keys(data).forEach(key => {
                    if (!jQuery(`.ag-region__code[value="${data[key].code}"]`).length) {
                        const markup = template({
                            key,
                            set,
                            ...data[key]
                        });
                        jQuery('.ag-region__list').append(markup);
                        added += 1;
                    }
                });

                if (!jQuery('.ag-region').length) {
                    const template = wp.template('ag-region-placeholder');
                    const markup = template();
                    jQuery('.ag-region__list').append(markup);
                } else {

                    jQuery('.ag-region-placeholder').remove();
                }

                const present = Object.keys(data).length - added;
                $('.meter > span').css({ width: '100%' });

                setTimeout(() => {
                    $('.wrap .progress').remove();
                    alert(`${added} regions. ${present ? `${present} already added` : ''}`);
                    this.validCheck();
                }, 1000)
            },
        });
    }

    updateFieldNames = (e) => {
        console.log(e.target.value.toLowerCase());
        const newCode = e.target.value.toLowerCase();
        const inputs = $(e.target).closest('li').find('input');
        const selects = $(e.target).closest('li').find('select');

        const regex = /(\[[^\]]*\])\[[^\]]*\]/;
        // var str = 'ag_settings[region][tt][redirect]';

        // var result = str.replace(re, '$1[999]');

        $.each(inputs, (i, el) => {
            el.name = el.name.replace(regex, `$1[${newCode}]`);
        });

        $.each(selects, (i, el) => {
            el.name = el.name.replace(regex, `$1[${newCode}]`);
        });
    }
}



window.addEventListener('DOMContentLoaded', function () {
    new AgeGateRegionsAdmin(jQuery);
});
